from random import *

from pgzhelper import *

TITLE = 'Avoid Cars'

WIDTH = 800
HEIGHT = 600

music.play('adventure')




def detect_border(actor):
  if actor.x > 750:  # Dépassement à droite
    actor.x = 750
  elif actor.x < 50:  # Dépassement à gauche
    actor.x = 50


class Player(Actor):

  def __init__(self, image, pos, **kwargs):
    super().__init__(image, pos, **kwargs)
    self.score = 0
    self.vie = 10
    self.en_collision = False

  def update(self):
    if keyboard.a:
      self.x -= 8  # Equivalent à self.x = self.x - 8
      if not player.flip_x:
        player.flip_x = True
    elif keyboard.d:
      self.x += 8  # Equivalent à self.x = self.x + 8
      if player.flip_x:
        player.flip_x = False
    detect_border(self)  # Appel de la fonction ici !
    impact = False
    for car in cars:
      if self.collides_with(car):
        impact = True
    if impact:
      if not self.en_collision:
        # Entre en collision
        self.vie -= 1
        self.en_collision = True
        sounds.explosion.play()
        if self.vie <= 0:
          sounds.gameover.play()
    else:
      # Sortie de collision
      self.en_collision = False
    if keyboard.r:
      self.en_collision = False
      self.vie = 10
      self.score = 0
      taille_lst_cars = len(cars)
      while taille_lst_cars > 3 :
        cars.remove(cars[taille_lst_cars-1])
        taille_lst_cars = len(cars)


class Cars(Actor):

  def __init__(self, image, pos, **kwargs):
    super().__init__(image, pos, **kwargs)

  def update(self):
    # Vitesse en fonction du score
    if player.score <= 10:
      self.y += 5
    elif player.score <= 20:
      self.y += 7
    else:
      self.y += 9
    if self.y > 600:
      self.y = 0
      route = randint(1, 3)
      if route == 1:
        self.x = 150
      if route == 2:
        self.x = 400
      if route == 3:
        self.x = 650


class Coin(Actor):

  def __init__(self, image, pos, **kwargs):
    super().__init__(image, pos, **kwargs)
    self.y = 450

  def update(self):
    if self.collides_with(player):
      player.score += 1
      sounds.gold_sack.play()
      coin = randint(1, 3)
      if coin == 1:
        self.x = 150
      if coin == 2:
        self.x = 400
      if coin == 3:
        self.x = 650


player = Player('bird1', (50, 450))
car1 = Cars("cars1", (150, HEIGHT / 70), width=150)
car2 = Cars("cars2", (400, HEIGHT / 4), width=150)
car3 = Cars("cars3", (650, HEIGHT / 120), width=150)
cars = [car1, car2, car3]  # Liste des voitures
coin = Coin("coin", (150, HEIGHT / 4), width=50)


def draw():
  screen.fill('#6D6D6D')
  rect = Rect((20, 0), (30, HEIGHT))
  screen.draw.filled_rect(rect, ("#FFFFFF"))
  for i in range(16):
    y = i * 50
    rect = Rect((250, y), (30, 20))
    screen.draw.filled_rect(rect, ("#FFFFFF"))

  for i in range(16):
    y = i * 50
    rect = Rect((500, y), (30, 20))
    screen.draw.filled_rect(rect, ("#FFFFFF"))

  rect = Rect((750, 0), (30, HEIGHT))
  screen.draw.filled_rect(rect, ("#FFFFFF"))

  screen.draw.text(f"Score: {player.score}", (10, 10), color=0)
  screen.draw.text(f"Vie: {player.vie}", (WIDTH - 100, 10), color=0)

  for car in cars:
    car.draw()
  if player.vie <= 0:
    screen.draw.text('__Game Over__', (WIDTH * 0.3, HEIGHT / 2.5),
                     color="black",
                     background="white",
                     fontsize=60)
    screen.draw.text('_Final Score: ' + str(player.score) + '_',
                     (WIDTH * 0.3, HEIGHT / 2.5 + 50),
                     color="black",
                     background="white",
                     fontsize=60)
    screen.draw.text('Pour recommencer tapez r', (WIDTH * 0.3 - 80, HEIGHT / 2.5 + 100),
       color="black",
       background="white",
       fontsize=60)
    player.x = 0  # Sur le cote pour stopper les collisions
  else:
    player.draw()
    coin.draw()


def update():
  player.update()
  # Ajout de voitures si score haut
  if len(cars) < 4 and player.score > 40:
    cars.append(Cars("cars2", (400, 0), width=150))
  if len(cars) < 5 and player.score > 50:
    cars.append(Cars("cars1", (150, 0), width=150))
  if len(cars) < 6 and player.score > 60:
    cars.append(Cars("cars3", (650, 0), width=150))
  for car in cars:
    car.update()
  coin.update()
