from pgzhelper import *
from random import *

TITLE = "Hit the fly"

WIDTH = 800
HEIGHT = 600


class Player(Actor):
    def __init__(self, image, pos, **kwargs):
        super().__init__(image, pos, **kwargs)
        self.speed = 5
        self.score = 0
        self.live = 3

    def update(self):
        if keyboard.a:
            self.x -= self.speed
            self.flip_x = True
        if keyboard.s:
            self.y += self.speed
        if keyboard.d:
            self.x += self.speed
            self.flip_x = False
        if keyboard.w:
            self.y -= self.speed

        detect_border(self)


class Ennemi(Actor):
    def __init__(self, image, pos, **kwargs):
        super().__init__(image, pos, **kwargs)
        self.speed = 5
        self.direction = randint(0, 360)
        self.images = ["fly1", "fly2"]

    def update(self):
        self.move_in_direction(self.speed)
        self.direction += randint(-30, 30)
        detect_border(self)
        if self.collides_with(player):
            self.to_remove = True
            player.live = player.live - 1


class Missile(Actor):
    def __init__(self, image, pos, direction, **kwargs):
        super().__init__(image, pos, **kwargs)
        self.direction = direction
        self.angle = direction
        self.speed = 5

    def update(self):
        self.move_in_direction(self.speed)
        for ennemi in ennemies:
            if self.collides_with(ennemi):
                sounds.explosion.play()
                ennemi.to_remove = True
                self.to_remove = True
                player.score = player.score + 1


class Coin(Actor):
    def __init__(self, image, pos, **kwargs):
        super().__init__(image, pos, **kwargs)

    def update(self):
        if player.collides_with(self):
            self.to_remove = True
            player.score = player.score + 1




def detect_border(actor):
    if actor.x < 0:
        actor.x = WIDTH
    if actor.x > WIDTH:
        actor.x = 0
    if actor.y < 0:
        actor.y = HEIGHT
    if actor.y > HEIGHT:
        actor.y = 0


def add_coin():
    coin = Coin("coin", (randint(0, WIDTH), randint(0, HEIGHT)), width=40)
    coins.append(coin)


def add_ennemy():
    ennemi = Ennemi("fly1", (randint(0, WIDTH), randint(0, HEIGHT)))
    ennemies.append(ennemi)


music.play("adventure")
clock.schedule_interval(add_ennemy, 3)
clock.schedule_interval(add_coin, 7)


def on_mouse_down(pos):
    direction = player.angle_to(pos)
    missile = Missile("laser1", (player.x, player.y), direction, width=40)
    missiles.append(missile)


player = Player("alien_walk1", (WIDTH / 2, HEIGHT / 2))
ennemies = []
missiles = []
coins = []


def draw():
    if player.live > 0:
        screen.blit("grass", (0, 0))
        screen.draw.text("Score: " + str(player.score), (0, 0))
        screen.draw.text("vies: " + str(player.live), (0, 30))
        player.draw()
        for ennemi in ennemies:
            ennemi.draw()
            ennemi.animate()
        for missile in missiles:
            missile.draw()
        for coin in coins:
            coin.draw()
        if player.score >= 20:
            screen.fill("blue")
            screen.draw.text("You win", center=(400, 300))
    if player.live == 0:
        screen.fill("black")
        screen.draw.text("GAME OVER", center=(400, 300))


def update():
    player.update()
    for ennemi in ennemies:
        ennemi.update()
    for coin in coins:
        coin.update()
    for missile in missiles:
        missile.update()

    remove_actors(ennemies)
    remove_actors(missiles)
    remove_actors(coins)
